# coding: utf-8



from collections import defaultdict, Counter

from intranet.dogma.dogma.core.models import ChangedFile


def get_changed_files_objects(changed_files, commit):
    return [
        ChangedFile(name=file_name,
                    commit=commit,
                    extension=file_data['extension'],
                    lines_added=file_data['additions'],
                    lines_deleted=file_data['deletions'],
                    )
        for file_name, file_data in changed_files.items()
    ]


def create_changed_files(changed_files, commit):
    changed_files_objects = get_changed_files_objects(changed_files, commit)
    ChangedFile.objects.bulk_create(changed_files_objects)


def collect_extensions_data(commit):
    result = defaultdict(Counter)
    for changed_file in commit.changed_files.all():
        result[changed_file.extension].update(lines_added=changed_file.lines_added,
                                              lines_deleted=changed_file.lines_deleted,
                                              )
    return result
