# coding: utf-8



from django.utils.timezone import now, timedelta
from django.db.models.query_utils import Q

from intranet.dogma.dogma.core.models import Clone


def get_clone_by_id(clone_id):
    return Clone.objects.filter(id=clone_id).select_related('repo', 'repo__source').first()


def get_clones_to_repair(sources_ids):
    fail_to = now() - timedelta(days=2)
    return Clone.objects.filter((Q(repo__last_sync_success_time__isnull=True) |
                                 Q(repo__last_sync_success_time__lt=fail_to)),
                                status=Clone.STATUSES.fail,
                                repo__source_id__in=sources_ids,
                                repo__on_remote=True,
                                repo__do_not_delete=False).prefetch_related('node')


def get_clones_on_current_node(status):
    return Clone.objects.on_current_node().filter(status=status)
