# coding: utf-8

import logging

from ylog.context import log_context
from dir_data_sync.models import Organization, get_default_operating_mode
from dir_data_sync.dir_client import DirClient, DirClientError

from intranet.dogma.dogma.utils import use_master_simple

log = logging.getLogger(__name__)


@use_master_simple
def get_connect_organization(dir_org_id):
    with log_context(dir_org_id=dir_org_id):
        try:
            return Organization.objects.get(dir_id=dir_org_id)
        except Organization.DoesNotExist:
            return None


@use_master_simple
def get_or_create_connect_organization(dir_org_id):
    with log_context(dir_org_id=dir_org_id):
        try:
            return Organization.objects.get(dir_id=dir_org_id)
        except Organization.DoesNotExist:
            log.info('Creating new organisation')
            try:
                org_obj = DirClient().get_organization(dir_org_id)
                dir_org_id = org_obj['id']
                name = org_obj['name']
                label = org_obj['label']
                lang = org_obj['language']
                mode = get_default_operating_mode()
                org = Organization.objects.create(
                    dir_id=dir_org_id,
                    name=name,
                    label=label,
                    lang=lang,
                    mode_id=mode,
                    status=Organization.ORG_STATUSES.enabled
                )
                return org
            except DirClientError:
                log.exception('Got exception while creating organisation')
