# coding: utf-8



from django.db import transaction

from intranet.dogma.dogma.core.models import UserFileStatistics


def insert_file_statistics_data(data_to_insert, date_to_insert, users_data_to_update):
    current_statistic = UserFileStatistics.objects.filter(user_id__in=users_data_to_update,
                                                          period__year=date_to_insert.year,
                                                          period__month=date_to_insert.month,
                                                          period__day=date_to_insert.day,
                                                          )
    current_statistic_map = {
        '{}_{}'.format(file_statistic.user_id,
                       file_statistic.extension): file_statistic
        for file_statistic in current_statistic
    }
    statistics_objects_to_create = []
    statistics_objects_to_update = []
    for extension_key, extension_data in data_to_insert.items():
        lines_added = extension_data['lines_added']
        lines_deleted = extension_data['lines_deleted']
        extension_object = current_statistic_map.get(extension_key)
        if extension_object:
            extension_object.lines_added += lines_added
            extension_object.lines_deleted += lines_deleted
            statistics_objects_to_update.append(extension_object)
        else:
            user_id, extension = extension_key.split('_', 1)
            statistics_objects_to_create.append(
                UserFileStatistics(
                    user_id=user_id,
                    extension=extension,
                    period=date_to_insert,
                    lines_added=lines_added,
                    lines_deleted=lines_deleted,
                )
            )

    with transaction.atomic():
        if statistics_objects_to_create:
            UserFileStatistics.objects.bulk_create(statistics_objects_to_create)
        for statistics_object in statistics_objects_to_update:
            statistics_object.save()
