# coding: utf-8



from intranet.dogma.dogma.core.models import Source
from django.utils.timezone import now, timedelta

def source_by_code(code):
    return Source.objects.filter(code=code).first()


def all_sources():
    return Source.objects.all()


def source_unavailable(source):
    return source.status == Source.SYNC_STATUSES.fail


def get_failed_sources():
    source_fail_from = now() - timedelta(days=1)
    return Source.objects.filter(status=Source.SYNC_STATUSES.fail,
                                 last_sync_success_time__lt=source_fail_from,
                                 )


def get_source_by_host(host):
    return Source.objects.filter(
        host=host,
    ).first()
