# coding: utf-8

from .base import (
    BaseError,
    EmptyRepositoryError,
    PermissionError,
    ConnectionError,
    NetworkError,
    NoRepositoryError,
    NoRepositoryOnNodeError,
    RemoteServiceError,
    SlowRemoteResponse,
)

ERRORS = (
    BaseError,
    EmptyRepositoryError,
    PermissionError,
    ConnectionError,
    NetworkError,
    NoRepositoryError,
    NoRepositoryOnNodeError,
    RemoteServiceError,
    SlowRemoteResponse,
)

ERRORS_MAP = {
    error.db_value: error
    for error in ERRORS
}
