# -*- coding: utf-8 -*-


from django.utils.translation import ugettext_lazy as _


class BaseError(Exception):
    help = _('Необработанная ошибка')

    # Если меняется значение db_value - нужно
    # провести миграцию, так как это значение
    # пишется в базу в last_sync_fail_error_code
    db_value = 'base_error'

    def __init__(self, cause=None):
        message = self.help
        if cause:
            message = cause
            if not isinstance(message, str):
                message = str(message)
        super(BaseError, self).__init__(message)
        self.cause = cause


class RemoteServiceError(BaseError):
    help = _('Ошибка внешнего сервиса')
    db_value = 'remote_server_error'


class ConnectionError(BaseError):
    help = _('Ошибка соединения')
    db_value = 'connection_error'


class NetworkError(BaseError):
    help = _('Сетевая ошибка')
    db_value = 'network_error'


class PermissionError(BaseError):
    help = _('Недостаточно прав для выполнения операции')
    db_value = 'permission_error'


class EmptyRepositoryError(BaseError):
    help = _('Репозиторий пуст')
    db_value = 'empty_repository_error'


class NoRepositoryError(BaseError):
    help = _('Репозиторий не найден или к нему нет доступа')
    db_value = 'no_repository_error'


class NoRepositoryOnNodeError(BaseError):
    help = _('Репозиторий отсутствует на файловой системе')
    db_value = 'no_repository_on_node_error'


class SlowRemoteResponse(BaseError):
    help = _('Не удалось получить ответ сервиса за отведенное время')
    db_value = 'slow_remote_response'
