# coding: utf-8


import logging
from functools import wraps

from intranet.dogma.dogma.celery_app import app
from ..utils import get_node_queue
from ..dao.node import get_nodes

log = logging.getLogger(__name__)

def skip_apply_async_error(e):
    if "OverLimit" in e.message:
        return True

    return False

def indexer_task(*celery_args, **celery_kwargs):
    """
    Этим декоратором следует оборачивать таски,
    которые ставит celerybeat и при этом они
    привязаны к определенным машинам (то есть
    одна такая таска должна быть запущена на каждой из машин)

    actually_run_task - если данный аргумент не был
    передан таске (ее поставил celerybeat) - декоратор
    ставит по одной такой таске на
    каждую из доступных машин передавая
    actually_run_task=True, чтобы
    на самих машинах таска начала реально
    выполняться
    """

    def _outer_wrapper(task):
        @_outer_wrapper.app_task
        @wraps(task)
        def _wrapper(*args, **kwargs):
            actually_run_task = kwargs.pop('actually_run_task', False)
            if actually_run_task:
                return task(*args, **kwargs)

            log.info('Sending tasks to queues')
            kwargs['actually_run_task'] = True
            nodes = get_nodes(enabled=True)
            for node in nodes:
                try:
                    _wrapper.apply_async(
                        args=args, kwargs=kwargs, queue=get_node_queue(name='clone', node=node),
                    )
                except Exception as e:
                    if not skip_apply_async_error(e):
                        raise
                    logging.exception('Got exception on node {} {}'.format(node.name, node.hostname))

        return _wrapper

    no_args = False
    if len(celery_args) == 1 and not celery_kwargs and callable(celery_args[0]):
        # Таска была обернута без передачи аргументов декоратору
        task_to_run = celery_args[0]
        no_args = True

    if no_args:
        _outer_wrapper.app_task = app.task
        return _outer_wrapper(task_to_run)
    else:
        _outer_wrapper.app_task = app.task(*celery_args, **celery_kwargs)
        return _outer_wrapper
