# coding: utf-8


import logging

from celery.exceptions import SoftTimeLimitExceeded


log = logging.getLogger(__name__)


def get_changed_files_map(batch_diff):
    changed_files_map = {}
    for commit_hex, diff in batch_diff.items():
        try:
            changed_files_map[commit_hex] = diff.changed_files
        except SoftTimeLimitExceeded:
            raise
        except Exception as exc:
            log.exception('Got exception while getting commit changed files "%s"', repr(exc))
    return changed_files_map


def update_extensions_data(data_to_insert, extensions_data, user):
    for extension, extension_data in extensions_data.items():
        key = '{}_{}'.format(user.id, extension)
        data_to_insert[key].update(extension_data)
    return data_to_insert
