# coding: utf-8



import logging
import os

import shutil

log = logging.getLogger(__name__)


def delete_clone(clone):
    log.info('Deleting "%s"', clone)

    if os.path.exists(clone.path):
        try:
            shutil.rmtree(clone.path)
            log.info('Successfully delete directory for clone "%s"', clone)
        except Exception:
            log.exception('Unable to remove directory %s', clone.path)
            return
    clone.delete()
    log.info('Successfully delete clone "%s"', clone)
