# coding: utf-8


import logging

log = logging.getLogger(__name__)


class CredentialClass(object):
    AUTH_TYPE = 'token'

    def get_credential_data(self, credential, default):
        if self.AUTH_TYPE == 'token':
            return self.get_token_data(credential, default)
        elif self.AUTH_TYPE == 'app_password':
            return self.get_app_password_data(credential, default)

    def get_token_data(self, credential, default):
        token = credential.auth_data.get('token')
        if not token:
            log.error('Dont get all needed data from credential "%s" ("%s")',
                      credential.id,
                      self.AUTH_TYPE,
                      )
            return default
        return token

    def get_app_password_data(self, credential, default):
        robot_login = credential.auth_data.get('login')
        app_password = credential.auth_data.get('app_password')
        if not all((robot_login, app_password)):
            log.error('Dont get all needed data from credential "%s" ("%s")',
                      credential.id,
                      self.AUTH_TYPE,
                      )
            return default
        return robot_login, app_password
