def parse_exception(exc):
    """
    Since not all classes have .stderr attribute
    we need to take this into account when parsing errors
    :type exc: Exception
    """

    base_e = exc.args[0]
    try:
        stdout = '\n'.join(base_e.stdout.rsplit('\n', 50)[1:])[:200]
        stderr = base_e.stderr[:200]
    except AttributeError:
        stdout = ''
        stderr = base_e
    return stdout, stderr
