from django.core.management.base import BaseCommand, CommandError

from intranet.dogma.dogma.core.models import User


class Command(BaseCommand):
    def add_arguments(self, parser):
        parser.add_argument('login', type=str, nargs='+')

    def handle(self, *args, **options):
        login = ' '.join(options['login'])

        user = User.objects.filter(login__iexact=login).first()
        if user:
            self.stdout.write('{user.name} <{user.email}>'.format(user=user))
        else:
            self.stdout.write('{login} <unknown@unknown.unknown>'.format(login=login))
