# coding: utf-8

from django.conf import settings
from django.core.exceptions import PermissionDenied
from django.contrib.auth.models import User
from dir_data_sync.models import Organization, OperatingMode
from rest_framework.exceptions import NotFound

from intranet.dogma.dogma.core.dao.connect_organization import get_or_create_connect_organization
from django_yauth.authentication_mechanisms.cookie import YandexUser
from django_yauth.middleware import YandexAuthMiddleware


class CheckExemptMixin(object):
    def check_exempt(self, attr, classes, ):
        return any(getattr(view, attr, False)
                   for view in classes)


class DogmaAuthMiddleware(CheckExemptMixin, YandexAuthMiddleware):
    def process_view(self, request, view_func, view_args, view_kwargs):
        view_class = getattr(view_func, 'view_class', None)
        no_auth = self.check_exempt('no_auth', (view_class, view_func))
        if not request.yauser.is_authenticated() and not no_auth:
            raise PermissionDenied('No valid authentication data was passed')


class DogmaMiddleware(object):
    def process_request(self, request):
        request.is_global = request.get_host() == settings.DOGMA_HOST


class DogmaOrgMiddleware(CheckExemptMixin, object):
    def process_view(self, request, view_func, view_args, view_kwargs):
        if settings.IS_DASHBOARD:
            return

        if settings.INSTANCE_TYPE == 'internal':
            dir_org_id = settings.INTERNAL_DIR_ID  # Организация yandex во внутреннем инстансе
        else:
            dir_org_id = request.META.get(settings.ORG_HEADER)
            if not dir_org_id:
                view_class = getattr(view_func, 'view_class', None)
                no_org = self.check_exempt('no_org', (view_class, view_func))
                if no_org:
                    return
                raise PermissionDenied('No org id in request found')
        org = get_or_create_connect_organization(dir_org_id)
        if not org:
            raise NotFound('Got error while getting organization')
        request.org = org


class DevelopmentAuthMiddleware(object):
    def process_request(self, request):
        request.yauser = YandexUser(uid='1120000000000529', fields={'login': 'test'})
        request.user, _ = User.objects.using('default').get_or_create(
            username='test', first_name='test', last_name='test',
            is_staff=True, is_superuser=True,
        )
        operating_mode, _ = OperatingMode.objects.using('default').get_or_create(
            name='test mode'
        )
        request.org, _ = Organization.objects.using('default').get_or_create(
            name='yandex', dir_id=settings.INTERNAL_DIR_ID,
            label='1', mode=operating_mode,
        )
