# -*- coding: utf-8 -*-


from django.db import models, migrations
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Clone',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, verbose_name='created', editable=False)),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, verbose_name='modified', editable=False)),
                ('status', models.CharField(max_length=20, choices=[('new', 'new'), ('active', 'active')])),
                ('space_required', models.BigIntegerField()),
                ('path', models.CharField(max_length=200)),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Node',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, verbose_name='created', editable=False)),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, verbose_name='modified', editable=False)),
                ('hostname', models.CharField(max_length=100)),
                ('space_total', models.BigIntegerField()),
                ('space_available', models.BigIntegerField()),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Repo',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, verbose_name='created', editable=False)),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, verbose_name='modified', editable=False)),
                ('name', models.CharField(max_length=100)),
                ('full_name', models.CharField(max_length=100)),
                ('owner', models.CharField(max_length=100)),
                ('web_url', models.CharField(max_length=200)),
                ('git_url', models.CharField(max_length=200)),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, verbose_name='created', editable=False)),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, verbose_name='modified', editable=False)),
                ('name', models.CharField(max_length=100)),
                ('code', models.SlugField()),
                ('vcs_type', models.CharField(max_length='20', choices=[('git', 'git'), ('svn', 'svn'), ('hg', 'hg'), ('bzr', 'bzr'), ('cvs', 'cvs')])),
                ('web_type', models.CharField(max_length='20', choices=[('github', 'github'), ('stash', 'stash'), ('websvn', 'websvn'), ('git', 'git')])),
                ('web_url', models.CharField(max_length=200)),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='repo',
            name='source',
            field=models.ForeignKey(to='core.Source'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='clone',
            name='node',
            field=models.ForeignKey(to='core.Node'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='clone',
            name='repo',
            field=models.ForeignKey(to='core.Repo'),
            preserve_default=True,
        ),
    ]
