# -*- coding: utf-8 -*-


from django.db import models, migrations
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0005_auto_20141224_0748'),
    ]

    operations = [
        migrations.CreateModel(
            name='BranchStamp',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=128, db_index=True)),
                ('head', models.CharField(max_length=40)),
                ('head_time', models.DateTimeField()),
                ('head_message', models.CharField(max_length=128)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='FetchEvent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, verbose_name='created', editable=False)),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, verbose_name='modified', editable=False)),
                ('clone', models.ForeignKey(to='core.Clone')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='branchstamp',
            name='fetch_event',
            field=models.ForeignKey(to='core.FetchEvent'),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='branchstamp',
            unique_together=set([('fetch_event', 'name')]),
        ),
    ]
