# -*- coding: utf-8 -*-


from django.db import models, migrations
import jsonfield.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0023_merge'),
    ]

    operations = [
        migrations.AddField(
            model_name='source',
            name='extra_info',
            field=jsonfield.fields.JSONField(default='{}', help_text='\u041c\u043e\u0436\u043d\u043e \u0434\u043e\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c {"basic": "username:password", "token": "token"}'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='repo',
            name='parent',
            field=models.ForeignKey(related_name='forks', blank=True, to='core.Repo', null=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name='source',
            name='use_crawler',
            field=models.BooleanField(default=True, help_text='\u0421\u043d\u0438\u043c\u0438\u0442\u0435, \u0435\u0441\u043b\u0438 \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0437\u0430\u043d\u043e\u0441\u0438\u0442\u044c \u0432 \u0431\u0430\u0437\u0443 \u0440\u0435\u043f\u043e\u0437\u0438\u0442\u043e\u0440\u0438\u0438, \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u043f\u0430\u0443\u043a\u0430'),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name='source',
            name='web_type',
            field=models.CharField(max_length='20', choices=[('github', 'github'), ('stash', 'stash'), ('websvn', 'websvn'), ('gitweb', 'gitweb'), ('hgweb', 'hgweb'), ('stash', 'stash'), ('gitlab', 'gitlab')]),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name='source',
            name='web_url',
            field=models.CharField(help_text='\u041d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0441\u043b\u0435\u0448 "/" \u0432 \u043a\u043e\u043d\u0446\u0435 \u0441\u0442\u0440\u043e\u043a\u0438', max_length=200),
            preserve_default=True,
        ),
    ]
