# -*- coding: utf-8 -*-


from django.db import models, migrations


def forward(apps, schema_editor):
    Repo = apps.get_model("core", "Repo")
    db_alias = schema_editor.connection.alias
    Repo.objects.using(db_alias).filter(
        name='aurora-platform-external-chromium_org-third_party-eyesfree-src-android-java-src-com-googlecode-eyesf'
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0025_auto_20160623_1657'),
    ]

    operations = [
        migrations.RunPython(forward),
        migrations.AlterField(
            model_name='clone',
            name='path',
            field=models.CharField(max_length=1000),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name='repo',
            name='name',
            field=models.CharField(max_length=250),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name='repo',
            name='vcs_name',
            field=models.CharField(max_length=250),
            preserve_default=True,
        ),
    ]
