# -*- coding: utf-8 -*-


from django.db import models, migrations


def delete_push_logs(apps, schema_editor):
    PushLog = apps.get_model('core', 'PushLog')
    PushLog.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0036_pushlog_unserialized_commits'),
    ]

    operations = [
        migrations.RunPython(delete_push_logs),
    ]
