# -*- coding: utf-8 -*-


from django.db import models, migrations
import django.contrib.postgres.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0053_auto_20170731_1723'),
    ]

    operations = [
        migrations.RunSQL('''CREATE INDEX queues_ind on core_pushedcommit USING GIN (queues)''',
                          '''DROP INDEX queues_ind''',
                          state_operations=[
                              migrations.AlterField(
                                  model_name='pushedcommit',
                                  name='queues',
                                  field=django.contrib.postgres.fields.ArrayField(db_index=True, null=True,
                                                                                  base_field=models.CharField(
                                                                                      max_length=50, blank=True),
                                                                                  size=None, blank=True),
                              )
                          ]),

        migrations.RunSQL('''CREATE INDEX tickets_ind on core_pushedcommit USING GIN (tickets)''',
                          '''DROP INDEX tickets_ind''',
                          state_operations=[
                              migrations.AlterField(
                                  model_name='pushedcommit',
                                  name='tickets',
                                  field=django.contrib.postgres.fields.ArrayField(db_index=True, null=True,
                                                                                  base_field=models.CharField(
                                                                                      max_length=100, blank=True),
                                                                                  size=None, blank=True),
                              ),
                          ]),

    ]
