# -*- coding: utf-8 -*-


from django.db import models, migrations
import django.contrib.postgres.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0055_auto_20170801_1652'),
    ]

    operations = [
        migrations.CreateModel(
            name='PushedCommitDuplicate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('already_pushed', models.BooleanField(default=False)),
                ('commit_time', models.DateTimeField(db_index=True)),
                ('lines_added', models.PositiveIntegerField()),
                ('lines_deleted', models.PositiveIntegerField()),
                ('message', models.TextField()),
                ('branch_name', models.CharField(max_length=80)),
                ('tree_hex', models.CharField(max_length=40)),
                ('commit_id', models.CharField(max_length=40)),
                ('commit_type', models.CharField(default='common', max_length=20, choices=[('common', 'common'), ('merge', 'merge')])),
                ('tickets', django.contrib.postgres.fields.ArrayField(null=True, base_field=models.CharField(max_length=100, blank=True), size=None, blank=True)),
                ('queues', django.contrib.postgres.fields.ArrayField(null=True, base_field=models.CharField(max_length=50, blank=True), size=None, blank=True)),
                ('commit', models.CharField(max_length=40)),
                ('author', models.ForeignKey(related_name='pushedcommitduplicate_author', to='core.User')),
                ('committer', models.ForeignKey(related_name='pushedcommitduplicate_committer', to='core.User')),
                ('parents', models.ManyToManyField(related_name='parents_rel_+', to='core.PushedCommitDuplicate')),
                ('push_in_batch', models.ForeignKey(to='core.PushLog', null=True)),
                ('repo', models.ForeignKey(to='core.Repo')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterField(
            model_name='pushedcommit',
            name='author',
            field=models.ForeignKey(related_name='pushedcommit_author', to='core.User'),
        ),
        migrations.AlterField(
            model_name='pushedcommit',
            name='committer',
            field=models.ForeignKey(related_name='pushedcommit_committer', to='core.User'),
        ),
    ]
