# -*- coding: utf-8 -*-


from django.db import models, migrations
import django.contrib.postgres.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0056_auto_20170823_1155'),
    ]

    operations = [
        migrations.RunSQL('''CREATE INDEX queues_dup_ind on core_pushedcommitduplicate USING GIN (queues)''',
                          '''DROP INDEX queues_dup_ind''',
                          state_operations=[
                              migrations.AlterField(
                                  model_name='pushedcommitduplicate',
                                  name='queues',
                                  field=django.contrib.postgres.fields.ArrayField(db_index=True, null=True,
                                                                                  base_field=models.CharField(
                                                                                      max_length=50, blank=True),
                                                                                  size=None, blank=True),
                              )
                          ]),

        migrations.RunSQL('''CREATE INDEX tickets_dup_ind on core_pushedcommitduplicate USING GIN (tickets)''',
                          '''DROP INDEX tickets_dup_ind''',
                          state_operations=[
                              migrations.AlterField(
                                  model_name='pushedcommitduplicate',
                                  name='tickets',
                                  field=django.contrib.postgres.fields.ArrayField(db_index=True, null=True,
                                                                                  base_field=models.CharField(
                                                                                      max_length=100, blank=True),
                                                                                  size=None, blank=True),
                              ),
                          ]),

    ]
