# -*- coding: utf-8 -*-


from django.db import models, migrations
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0062_node_name'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='pushlog',
            name='repo',
        ),
        migrations.RemoveField(
            model_name='pushedcommit',
            name='already_pushed',
        ),
        migrations.RemoveField(
            model_name='pushedcommit',
            name='push_in_batch',
        ),
        migrations.RemoveField(
            model_name='pushedcommitduplicate',
            name='already_pushed',
        ),
        migrations.RemoveField(
            model_name='pushedcommitduplicate',
            name='push_in_batch',
        ),
        migrations.RemoveField(
            model_name='repo',
            name='pushed_to_intrasearch_successfully',
        ),
        migrations.RemoveField(
            model_name='source',
            name='intrasearch_pct',
        ),
        migrations.AddField(
            model_name='pushedcommit',
            name='created',
            field=model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, verbose_name='created', editable=False),
        ),
        migrations.AddField(
            model_name='pushedcommit',
            name='modified',
            field=model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, verbose_name='modified', editable=False),
        ),
        migrations.AddField(
            model_name='pushedcommitduplicate',
            name='created',
            field=model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, verbose_name='created', editable=False),
        ),
        migrations.AddField(
            model_name='pushedcommitduplicate',
            name='modified',
            field=model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, verbose_name='modified', editable=False),
        ),
        migrations.AlterField(
            model_name='repo',
            name='contiguous_chain_of_commits_ends_at',
            field=models.ForeignKey(related_name='repo_last_known_commit', to='core.PushedCommit', help_text='\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043a\u043e\u043c\u043c\u0438\u0442', null=True),
        ),
        migrations.DeleteModel(
            name='PushLog',
        ),
    ]
