# -*- coding: utf-8 -*-


from django.db import models, migrations
import django.utils.timezone
import django.contrib.postgres.fields
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0074_repo_organisation'),
    ]

    operations = [
        migrations.CreateModel(
            name='Credential',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, verbose_name='created', editable=False)),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, verbose_name='modified', editable=False)),
                ('auth_type', models.CharField(max_length=100, choices=[('token', 'token'), ('app_password', 'app_password')])),
                ('name', models.CharField(max_length=250)),
                ('auth_data', django.contrib.postgres.fields.JSONField()),
                ('is_success', models.BooleanField(default=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='organisationstoclone',
            name='credentials',
            field=models.ManyToManyField(to='core.Credential', blank=True),
        ),
        migrations.AddField(
            model_name='repo',
            name='credentials',
            field=models.ManyToManyField(to='core.Credential', blank=True),
        ),
        migrations.AddField(
            model_name='credential',
            name='connect_organization',
            field=models.ForeignKey(to='dir_data_sync.Organization'),
        ),
    ]
