# coding: utf-8
import logging
import pygit2

from ..git.models import Repository as GitRepository
from ..git.models import Commit


log = logging.getLogger(__name__)


class Repository(GitRepository):
    def list_branches(self, type_='both'):
        return super(Repository, self).list_branches(type_=type_)

    def branch_head(self, branch_name):
        branch_type = pygit2.GIT_BRANCH_REMOTE if branch_name.startswith('origin/') else pygit2.GIT_BRANCH_LOCAL
        head = self._initial.lookup_branch(branch_name, branch_type).peel()
        if head is not None:
            return Commit(head)
