# coding: utf-8



from django.conf.urls import url
from . import views


urlpatterns = [
    url('^$', views.index, name='index'),

    url('^sources/$',
        views.sources_list,
        name='sources_list'),

    url('^sources/(?P<pk>\d+)/fetch_by_type$',
        views.source_update_by_type,
        name='source_update_by_type'),

    url('^sources/(?P<pk>\d+)/((?P<action>\w+)/)?$',
        views.source_details,
        name='source_details'),

    url('^repos/$',
        views.repos_list,
        name='repos_list'),

    url('^repos/(?P<pk>\d+)/((?P<action>[\w ]+)/)?$',
        views.repo_details,
        name='repo_details'),

    url('^failed_repos/$',
        views.failed_repos,
        name='failed_repos'),

    url('^straggled_repos/$',
        views.straggled_repos,
        name='straggled_repos'),

    url('^nodes/$',
        views.nodes_list,
        name='nodes_list'),

    url('^clones/(?P<pk>\d+)/((?P<action>\w+)/)?$',
        views.clone_details,
        name='clone_details'),

    url('^stat/commits_by_months/?$',
        views.commits_stat_by_users_by_months,
        name='stat_commits_by_months'),

]
