# coding: utf-8

from pymongo import MongoClient

from django.conf import settings


_mongo_client = None


def get_mongo_client():
    global _mongo_client
    if _mongo_client is None:
        _mongo_client = MongoClient(settings.CELERY_BROKER_URL, tz_aware=True)[settings.MONGO_DB]
    return _mongo_client
