# coding: utf-8
from .common_views import ping

from django.conf.urls import url, include
from django.conf.urls.static import static
from django.conf import settings
from django.contrib import admin

from intranet.dogma.dogma.api.views.common import UnistatView

urlpatterns = [
    url(r'^admin/', include(admin.site.urls)),
    url(r'^api/v3/', include(('intranet.dogma.dogma.api.urls', 'api'), namespace='api')),
    url(r'^api/', include(('intranet.dogma.dogma.api.urls', 'api'), namespace='api')),
    url(r'', include(('intranet.dogma.dogma.dashboard.urls', 'dashboard'), namespace='dashboard')),
    url(r'^ping/?', ping),
    url(r'^unistat/?', UnistatView.as_view(), name='unistat'),
]

if not settings.IS_DASHBOARD:
    urlpatterns += [
        url(r'^api/v4/', include(('intranet.dogma.dogma.api_v4.urls', 'api_v4'), namespace='api_v4')),
    ]

urlpatterns += static(
    settings.STATIC_URL,
    document_root=settings.STATIC_ROOT,
)
