from contextlib import contextmanager
from django.conf import settings
from django.utils.decorators import ContextDecorator
from django_replicated.utils import routers


def get_slave_or_master():
    return next(
        filter(lambda db_name: db_name != 'default', list(settings.DATABASES.keys())), 'default'
    )


@contextmanager
def switch_db_to(state):
    routers.use_state(state)
    try:
        yield
    finally:
        routers.revert()


class use_state_simple(ContextDecorator):
    def __init__(self, state):
        self.state = state

    def __enter__(self):
        routers.use_state(self.state)

    def __exit__(self, exc_type, exc_val, exc_tb):
        routers.revert()


use_master_simple = use_state_simple('master')
use_slave_simple = use_state_simple('slave')
