PY3_LIBRARY(dogma)

OWNER(g:dogma)

PEERDIR(
    contrib/python/more-itertools
    contrib/python/pathlib2
    contrib/python/cryptography
    contrib/python/celery/py2
    contrib/python/django/django-1.11
    contrib/python/djangorestframework
    contrib/python/django-model-utils
    contrib/python/django-waffle
    contrib/python/lxml
    contrib/python/pygit2
    contrib/python/requests
    contrib/python/uwsgi
    contrib/python/uritemplate
    contrib/python/zope.interface
    contrib/python/sh
    contrib/python/schematics
    contrib/python/six
    contrib/python/django-replicated
    contrib/python/dateutil
    contrib/python/pytz
    contrib/python/ipython
    contrib/python/jsonfield
    contrib/python/cached-property
    contrib/python/mercurial
    contrib/python/pretend
    contrib/python/chardet
    contrib/python/setuptools
    contrib/python/psycopg2
    contrib/python/github3.py
    contrib/python/numpy
    contrib/python/unidiff
    contrib/python/whitenoise
    library/python/yenv
    contrib/python/gunicorn
    contrib/python/zero-downtime-migrations
    contrib/python/python-memcached

    library/python/django
    library/python/django_pgaas
    library/python/datasources-config-wrapper
    library/python/ylock
    library/python/python-django-yauth
    library/python/granular_settings
    library/python/ylog
    library/python/django_tools_log_context
    library/python/ids
    library/python/dir-sync
)

PY_SRCS(
    __init__.py
    celery_app.py
    common_views.py
    settings.py
    mongo.py
    manage.py
    urls.py
    utils.py
    waffle_switches.py
)


RESOURCE_FILES(
    PREFIX intranet/dogma/dogma/

    settings/130-ylock.conf
    settings/200-gerrit.conf
    settings/040-middleware.conf.development.unittest
    settings/100-databases.conf
    settings/071-celery.conf.development.unittest
    settings/190-dirsync.conf
    settings/080-yauth.conf
    settings/030-apps.conf
    settings/001-datasources.conf.local.example
    settings/040-middleware.conf
    settings/biz/082-tvm_yauth.conf
    settings/biz/191-dirsync.conf
    settings/biz/071-celery.conf
    settings/biz/111-dogma.conf
    settings/biz/111-dogma.conf.production
    settings/biz/021-security.conf
    settings/biz/081-yauth.conf
    settings/biz/091-logging.conf
    settings/110-dogma.conf.development
    settings/000-debug.conf.development
    settings/180-users.conf
    settings/001-datasources.conf
    settings/000-instance_type.conf
    settings/000-debug.conf.development.unittest
    settings/081-tvm_yauth.conf
    settings/060-mongo.conf
    settings/020-security.conf
    settings/internal/082-tvm_yauth.conf
    settings/internal/071-celery.conf
    settings/internal/111-dogma.conf
    settings/internal/111-dogma.conf.production
    settings/internal/071-celery.conf.production
    settings/160-timings.conf
    settings/110-dogma.conf.development.unittest
    settings/001-datasources.conf.production
    settings/051-django.conf.development
    settings/020-security.conf.development
    settings/190-dirsync.conf.testing
    settings/070-celery.conf
    settings/120-alive.conf
    settings/140-cache.conf
    settings/120-misc.conf
    settings/040-middleware.conf.development
    settings/010-paths.conf
    settings/100-databases.conf.development.unittest
    settings/090-logging.conf
    settings/050-django.conf
    settings/110-dogma.conf
    settings/170-commits.conf
    settings/140-cache.conf.development
    settings/000-debug.conf
    settings/001-datasources.conf.testing
    settings/080-yauth.conf.development.unittest
    settings/130-ylock.conf.development.unittest
    settings/091-logging.conf.development.unittest
)

END()
