PY3TEST()

OWNER(g:dogma)

ENV(PYTEST_ADDOPTS=-l)
ENV(DJANGO_SETTINGS_MODULE=intranet.dogma.dogma.settings)
ENV(YENV_TYPE=development.unittest)

INCLUDE(${ARCADIA_ROOT}/antiadblock/postgres_local/recipe/recipe.inc)
DEPENDS(
  antiadblock/postgres_local/recipe
)

SIZE(MEDIUM)

REQUIREMENTS(
    cpu:4 ram:12
)

NO_CHECK_IMPORTS()

DATA(
    sbr://1042753119=hg
    sbr://1042759437=git
    sbr://1045978538=magiclinks
    arcadia/intranet/dogma/fixtures
)

PEERDIR(
    intranet/dogma/dogma/api
    intranet/dogma/dogma/api_v4
    intranet/dogma/dogma/core
    intranet/dogma/dogma/core/migrations
    intranet/dogma/dogma/dashboard
    intranet/dogma/dogma

    contrib/python/pytest-django
    contrib/python/vcrpy
    contrib/python/mock
    contrib/python/ipdb
    contrib/python/factory-boy
    contrib/python/py
)



TEST_SRCS(
    conftest.py
    core/test_crawlers.py
    core/backends/test_gerrit.py
    core/backends/test_git.py
    core/backends/__init__.py
    core/backends/test_svn.py
    core/backends/test_hg.py
    core/dao/test_file_statistics.py
    core/dao/commits.py
    core/dao/__init__.py
    core/dao/test_users.py
    core/logic/test_changed_files.py
    core/logic/test_task_processing.py
    core/logic/__init__.py
    core/logic/test_users.py
    core/__init__.py
    core/test_tasks.py
    core/test_models.py
    core/hg/test_repository.py
    core/hg/__init__.py
    core/hg/test_diff.py
    core/hg/utils.py
    core/git/__init__.py
    core/git/utils.py
    __init__.py
    dashboard/__init__.py
    dashboard/factories.py
    dashboard/test_smoke.py
    utils.py
    api_v4/conftest.py
    api_v4/test_credential.py
    api_v4/__init__.py
    api_v4/test_organization.py
    api_v4/test_repo.py
    api/test_repository.py
    api/test_file_statistics.py
    api/conftest.py
    api/test_commits.py
    api/test_forks.py
    api/test_branches.py
    api/__init__.py
    api/test_contents.py
    api/utils.py
    api/test_compare.py
    api/test_blob.py
)

END()
