#!/bin/bash
set -e

# get domains_cache
get_domain_cache > /dev/null 2>&1
service cron start

# Start push-client if env is set
if [[ ${ENV_TYPE} == production ]]; then
    mkdir -p /var/run/statbox/
    /usr/bin/push-client -w --pid /var/run/statbox/push-client.pid -c /etc/yandex/statbox-push-client/push-client.yaml
fi

# Select mode and start
if [ "$MODE" = "worker" ]; then
    /arq intranet.domenator.src.worker.settings.WorkerSettings;
else
    /domenator-main --config=file:/hypercorn_conf.py intranet.domenator.src.asgi.app:app;
fi
