import os
import sys

from sqlalchemy.engine.url import URL
from alembic.config import CommandLine, Config

from library.python import resource

from intranet.domenator.src.settings import config


def extract_resources(prefix):
    for res, data in resource.iteritems(prefix='resfs/file/{}'.format(prefix), strip_prefix=True):
        path = os.path.join('migrations', res)
        if not os.path.exists(path):
            parent = os.path.normpath(os.path.join(path, os.pardir))
            if not os.path.exists(parent):
                os.makedirs(parent)
            with open(path, 'wb') as f:
                f.write(data)


def main():
    extract_resources('intranet/domenator/migrations/')
    dsn = str(
        URL(
            drivername=config.db_drivername,
            username=config.db_username,
            password=config.db_password,
            host=config.db_host,
            port=config.db_port,
            database=config.db_name,
        )
    )

    alembic_cfg = Config()
    alembic_cfg.set_main_option('sqlalchemy.url', dsn)
    sys.exit(CommandLine().main())


if __name__ == '__main__':
    main()
