"""add service_id and expired_at to mail_users_domains

Revision ID: 24c98fb307b8
Revises: c9055fc0384f
Create Date: 2021-12-07 11:04:41.786362+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '24c98fb307b8'
down_revision = 'c9055fc0384f'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('mail_users_domains', sa.Column('expired_at', sa.Date(), nullable=True))
    op.add_column('mail_users_domains', sa.Column('service_id', sa.VARCHAR(length=50), nullable=True))
    op.create_index(op.f('ix_mail_users_domains_expired_at'), 'mail_users_domains', ['expired_at'], unique=False)


def downgrade():
    op.drop_index(op.f('ix_mail_users_domains_expired_at'), table_name='mail_users_domains')
    op.drop_column('mail_users_domains', 'service_id')
    op.drop_column('mail_users_domains', 'expired_at')
