"""add_mail_user_domains

Revision ID: 440597230a96
Revises: 3fbf7809fa09
Create Date: 2021-02-05 17:59:16.402110+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '440597230a96'
down_revision = '3fbf7809fa09'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('mail_users_domains',
        sa.Column('domain', sa.VARCHAR(length=253), autoincrement=False, nullable=False),
        sa.Column('status', sa.VARCHAR(length=50), autoincrement=False, nullable=False),
        sa.Column('fields', postgresql.JSONB(astext_type=sa.Text()), autoincrement=False, nullable=True),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('CURRENT_TIMESTAMP'), autoincrement=False, nullable=True),
        sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column('uid', sa.VARCHAR(length=20), autoincrement=False, nullable=False),
        sa.PrimaryKeyConstraint('id', name='mail_users_domains_pkey')
    )


def downgrade():
    op.drop_table('mail_users_domains')
