"""add domain_history table

Revision ID: 6f0f5c604c46
Revises: f19d5e0262a5
Create Date: 2020-09-10 12:23:29.766631+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '6f0f5c604c46'
down_revision = 'f19d5e0262a5'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('domain_history',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('org_id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.Unicode(), nullable=False),
    sa.Column('action', sa.Enum('domain_occupied', 'domain_deleted', 'domain_added', 'domain_alienated', 'domain_auto_handover', 'domain_deleted_with_organization', name='domainaction'), nullable=False),
    sa.Column('author_id', sa.Unicode(), nullable=True),
    sa.Column('timestamp', sa.TIMESTAMP(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_domain_history_name'), 'domain_history', ['name'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_domain_history_name'), table_name='domain_history')
    op.drop_table('domain_history')
    op.execute('DROP TYPE if exists domainaction')
    # ### end Alembic commands ###
