"""add_domain_table

Revision ID: f3af7f84d4b3
Revises: caea6de4c86b
Create Date: 2020-07-29 09:57:12.958385+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f3af7f84d4b3'
down_revision = 'caea6de4c86b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('domains',
    sa.Column('org_id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.Unicode(), nullable=False),

    sa.Column('delegated', sa.Boolean(), nullable=False, server_default='false'),
    sa.Column('master', sa.Boolean(), nullable=False, server_default='false'),
    sa.Column('mx', sa.Boolean(), nullable=False, server_default='false'),
    sa.Column('owned', sa.Boolean(), nullable=False, server_default='false'),
    sa.Column('validated', sa.Boolean(), nullable=False, server_default='false'),
    sa.Column('via_webmaster', sa.Boolean(), nullable=False, server_default='false'),

    sa.Column('blocked_at', sa.TIMESTAMP(timezone=True), nullable=True),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), nullable=True, server_default=sa.func.now()),
    sa.Column('validated_at', sa.TIMESTAMP(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('org_id', 'name')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('domains')
    # ### end Alembic commands ###
