from fastapi import Request, status
from starlette.exceptions import HTTPException


class ListParser:
    def __init__(
        self,
        param_name: str,
        required: bool = False,
        default=None,
        el_caster=None,
        container=list,
    ):
        self.param_name = param_name
        self.required = required
        self.default = default
        self.el_caster = el_caster
        self.container = container

    def _raise_exception(self):
        raise HTTPException(
            status.HTTP_422_UNPROCESSABLE_ENTITY,
            'Parameter \'{param_name}\' must contain comma separated list of {type}'.format(
                param_name=self.param_name,
                type=self.el_caster.__name__ if self.el_caster else 'str'
            )
        )

    def __call__(self, request: Request):
        raw_param = request.query_params.get(self.param_name)
        if raw_param is None:
            if self.required:
                self._raise_exception()
            return self.default

        raw_items = raw_param.split(',')
        if not self.el_caster:
            return self.container(raw_items)

        try:
            return self.container(map(self.el_caster, raw_items))
        except ValueError:
            self._raise_exception()
