from datetime import datetime

from pydantic import BaseModel, validator
from typing import Optional

from intranet.domenator.src.logic.domain import from_punycode


class PrivateDomainOutSchema(BaseModel):
    org_id: Optional[int]
    name: Optional[str]
    owned: Optional[bool]
    master: Optional[bool]
    display: Optional[bool]
    blocked_at: Optional[datetime]
    created_at: Optional[datetime]
    delegated: Optional[bool]
    mx: Optional[bool]
    validated: Optional[bool]
    validated_at: Optional[datetime]
    via_webmaster: Optional[bool]

    class Config:
        orm_mode = True

    @validator("name")
    def decode_from_punycode(cls, name: str):
        return from_punycode(name)


class PrivateDomainUpdateSchema(BaseModel):
    master: Optional[bool]
    display: Optional[bool]
    owned: Optional[bool]
    blocked_at: Optional[datetime]
