import os
import sys
import asyncio
from typing import cast
from logging.config import dictConfig
import click
from arq.worker import create_worker
from pydantic.utils import import_string

from intranet.domenator.src.redis import create_redis_pool
from intranet.domenator.src.domenator_logging.settings import LOGGING


@click.command('arq')
@click.argument('worker-settings', type=str, required=True)
def cli(*, worker_settings: str) -> None:
    sys.path.append(os.getcwd())
    worker_settings_ = cast('WorkerSettingsType', import_string(worker_settings))
    dictConfig(LOGGING)

    loop = asyncio.get_event_loop()
    pool = loop.run_until_complete(create_redis_pool())
    worker = create_worker(worker_settings_, redis_pool=pool)
    worker.run()
