from gino.ext.starlette import Gino
from sqlalchemy.engine.url import URL
from intranet.domenator.src.settings import config
from gino.dialects.asyncpg import Pyscopg2Pool


def get_engine_config():
    return {
        'dsn': URL(
            drivername=config.db_drivername,
            username=config.db_username,
            password=config.db_password,
            host=config.db_host,
            port=config.db_port,
            database=config.db_name,
        ),
        'ssl': config.db_ssl,
        'echo': config.db_echo,
        'pool_min_size': config.db_pool_min_size,
        'pool_max_size': config.db_pool_max_size,
        'use_connection_for_request': config.db_use_connection_for_request,
        'retry_limit': config.db_retry_limit,
        'retry_interval': config.db_retry_interval,
        'kwargs': {'pool_class': Pyscopg2Pool, },
    }


db = Gino(**get_engine_config())
