from datetime import datetime
from sqlalchemy.dialects.postgresql import JSONB

from ..engine import db


class Event(db.Model):
    __tablename__ = 'events'

    id = db.Column(db.BigInteger(), primary_key=True)
    name = db.Column(db.Unicode(), nullable=False)
    created_at = db.Column(db.TIMESTAMP(timezone=True), default=datetime.utcnow, nullable=False)
    data = db.Column(JSONB)
    is_processed = db.Column(db.Boolean(), default=False, nullable=False)
