from pyscopg2.asyncpg import PoolManager

from intranet.domenator.src.settings import config


def get_dsn() -> str:
    username = config.db_username
    password = config.db_password
    hosts = config.db_host
    database = config.db_name
    host_str = ','.join([f'{host}:{config.db_port}' for host in hosts.split(',')])
    return f'postgresql://{username}:{password}@{host_str}/{database}'


def get_pool_config():
    return {
        'ssl': config.db_ssl,
        'min_size': config.db_pool_min_size,
        'max_size': config.db_pool_max_size,
    }


async def init_pool() -> PoolManager:
    dsn = get_dsn()
    return PoolManager(dsn, fallback_master=True, pool_factory_kwargs=get_pool_config())
