from ..engine import db
from ...logic.types import PDDVersion


class Registrar(db.Model):
    __tablename__ = 'registrars'

    id = db.Column(db.BigInteger(), primary_key=True)

    pdd_id = db.Column(db.BigInteger())
    pdd_version = db.Column(db.Enum(PDDVersion))
    name = db.Column(db.String(), nullable=False)
    admin_id = db.Column(db.Unicode(), nullable=False)
    password = db.Column(db.String(), nullable=False)
    oauth_client_id = db.Column(db.String())
    # Соответствует payed_url из старого API ПДД
    validate_domain_url = db.Column(db.String())
    # Соответствует added_init
    domain_added_callback_url = db.Column(db.String())
    # Соответствует added
    domain_verified_callback_url = db.Column(db.String())
    # Соответствует delete_url
    domain_deleted_callback_url = db.Column(db.String())
    # токен регистратора - применимо только для новых регистраторов
    token = db.Column(db.String())
    # соль для паролей - применимо только для новых регистраторов
    iv = db.Column(db.String())
    # длина пароля новых - применимо только для новых регистраторов
    plength = db.Column(db.Integer(), default=0)
