import uuid
from .base import BaseProvider, context_field


class ArqJobProvider(BaseProvider):
    @property
    def arq_task(self):
        return self.kwargs.get('arq_task')

    @property
    def arq_context(self):
        return self.kwargs.get('arq_context')

    @context_field('arq')
    def arq(self):
        context = {}
        if self.arq_task is not None:
            context.update({
                'job_name': self.arq_task.__name__,
            })
        if self.arq_context is not None:
            context.update({
                'job_id': self.arq_context.get('job_id'),
                'job_try': self.arq_context.get('job_try'),
                'score': self.arq_context.get('score'),
            })
        return context

    @context_field('arq')
    def request_id(self):
        return str(uuid.uuid4())

    @context_field('arq')
    def ycrid(self):
        return self.arq_context.get('ycrid')
