import sys
import os
import logging

from intranet.domenator.src.settings import config

LOG_FORMAT = 'json'
ENV_LOG_LEVEL = 'DEBUG' if config.debug else 'INFO'

LOG_DIR = '/var/log/yandex/domenator'

tskv_formatter = 'intranet.domenator.src.domenator_logging.logger.TSKVFormatter'

LOG_STREAM = sys.stdout

# if config.env_type == 'development' and not os.environ.get('ARCADIA') and os.environ.get('DOCKER'):
#     LOG_STREAM = open('/var/log/yandex/domenator/autotests.log', 'a')
# else:
#     # если проект запущен в терминале, руками, то лог будем писать в yandex-directory.log
#     if sys.stdout.isatty():
#         LOG_STREAM = open('domenator.log', 'a')

LOG_FORMATTERS = {
    'access_tskv': {
        '()': tskv_formatter,
        'fmt': "tskv\ttskv_format=ydisk-domenator-access-log\thost=%(host_name)s\tname=%(name)s\tappname=%(appname)s\tunixtime=%(created)d\ttimestamp=%(asctime)s\ttimezone=+0300\tycrid=%(ycrid)s\tpid=%(process)s\tmodule=%(module)s\theaders=%(headers)s\tmethod=%(method)s\tuid=%(uid)s\turi=%(uri)s\tproto=%(proto)s\tstatus=%(status)s\trequest_time=%(request_time).3f\trequest_id=%(request_id)s"  # noqa: E501
    },
    'default_tskv': {
        '()': tskv_formatter,
        'fmt': "tskv\ttskv_format=ydisk-domenator-default-log\thost=%(host_name)s\tname=%(name)s\tappname=%(appname)s\tunixtime=%(created)d\ttimestamp=%(asctime)s\ttimezone=+0300\tycrid=%(ycrid)s\tpid=%(process)s\tmodule=%(module)s\tlevel=%(levelname)s\tmessage=%(message)s\trequest_id=%(request_id)s"  # noqa: E501
    },
    'error_tskv': {
        '()': tskv_formatter,
        'fmt': "tskv\ttskv_format=ydisk-domenator-error-log\thost=%(host_name)s\tname=%(name)s\tappname=%(appname)s\tunixtime=%(created)d\ttimestamp=%(asctime)s\ttimezone=+0300\tycrid=%(ycrid)s\tpid=%(process)s\tmodule=%(module)s\tmessage=%(message)s\trequest_id=%(request_id)s"  # noqa: E501
    },
    'requests_tskv': {
        '()': tskv_formatter,
        'fmt': "tskv\ttskv_format=ydisk-domenator-requests-log\thost=%(host_name)s\tname=%(name)s\tappname=%(appname)s\tunixtime=%(created)d\ttimestamp=%(asctime)s\ttimezone=+0300\tycrid=%(ycrid)s\tpid=%(process)s\tmodule=%(module)s\tmessage=%(message)s\trequest_time=%(request_time).3f\trequest_id=%(request_id)s\tclient_name=%(client_name)s"  # noqa: E501
    },
}

LOGGERS = {
    'dom_access': {
        'level': logging.DEBUG,
        'handlers': ['dom_access', 'stream'],
    },
    'dom_default': {
        'level': logging.DEBUG,
        'handlers': ['dom_default', 'stream'],
    },
    'dom_error': {
        'level': logging.DEBUG,
        'handlers': ['dom_error', 'stream'],
    },
    'dom_requests': {
        'level': logging.DEBUG,
        'handlers': ['dom_requests', 'stream'],
    },
}

if os.environ.get('DEPLOY_STAGE_ID', os.environ.get('QLOUD_ENVIRONMENT')) is not None or config.env_type == 'development' and os.environ.get('DOCKER'):
    LOG_FORMATTER = 'json'
    LOG_HANDLERS = {
        'dom_access': {
            'class': 'logging.handlers.WatchedFileHandler',
            'formatter': 'access_tskv',
            'filename': f'{LOG_DIR}/access-tskv.log',
            'level': 'DEBUG',
        },
        'dom_default': {
            'class': 'logging.handlers.WatchedFileHandler',
            'formatter': 'default_tskv',
            'level': 'DEBUG',
            'filename': f'{LOG_DIR}/default-tskv.log',
        },
        'dom_error': {
            'class': 'logging.handlers.WatchedFileHandler',
            'formatter': 'error_tskv',
            'level': 'DEBUG',
            'filename': f'{LOG_DIR}/error-tskv.log',
        },
        'dom_requests': {
            'class': 'logging.handlers.WatchedFileHandler',
            'formatter': 'requests_tskv',
            'level': 'DEBUG',
            'filename': f'{LOG_DIR}/requests-tskv.log',
        },
    }
else:
    LOG_FORMATTER = 'default'
    LOG_HANDLERS = {
        'dom_default': {
            'class': 'logging.StreamHandler',
            'formatter': 'default_tskv',
            'level': ENV_LOG_LEVEL,
        },
        'dom_requests': {
            'class': 'logging.StreamHandler',
            'formatter': 'requests_tskv',
            'level': ENV_LOG_LEVEL,
        },
        'dom_error': {
            'class': 'logging.StreamHandler',
            'formatter': 'error_tskv',
            'level': ENV_LOG_LEVEL,
        },
        'dom_access': {
            'class': 'logging.StreamHandler',
            'formatter': 'access_tskv',
            'level': ENV_LOG_LEVEL,
        }
    }

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,

    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
        **LOG_FORMATTERS,
    },
    'loggers': {
        'tvm2.aio.base': {
            'handlers': [],
            'level': ENV_LOG_LEVEL,
            'propagate': False,
        },
        'intranet.domenator.src': {
            'handlers': ['stream'],
            'propagate': False,
            'level': ENV_LOG_LEVEL,
        },
        'gino.engine': {
            'handlers': ['dom_default', 'stream'],
            'propagate': False,
            'level': ENV_LOG_LEVEL,
        },
        'ya.test': {'level': 'WARNING'},
        **LOGGERS,
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMATTER,
            'stream': LOG_STREAM,
            'level': ENV_LOG_LEVEL,
        },
        'null': {
            'level': 'DEBUG',
            'class': 'logging.NullHandler',
        },
        **LOG_HANDLERS,
    }
}
