from async_clients.clients.connect import Client as ConnectClient

from intranet.domenator.src.settings import config
from intranet.domenator.src.logic.tvm2 import get_service_ticket
from intranet.domenator.src.domenator_logging.middleware.profiling_client import ProfilingClientMixin


class ConnectProfilingClient(ConnectClient, ProfilingClientMixin):
    CLIENT_NAME = 'connect'

    async def bulk_get_domains(self, domains):
        data = {
            'domains': list(domains),
            'fields': ["org_id"],
        }
        return await self._make_request(
            method='post',
            path='/v11/domains/search/',
            json=data,
        )


async def get_connect_client() -> ConnectProfilingClient:
    return ConnectProfilingClient(
        host=config.connect_host,
        service_ticket=await get_service_ticket(config.connect_tvm2_client)
    )


async def get_domains_in_connect(domains):
    connect = await get_connect_client()
    domains = await connect.bulk_get_domains(domains)
    return set(domains)
