import random
from typing import Type

import dns.asyncresolver as dns_asyncresolver
from intranet.domenator.src.settings import config
from .utils import timeit


class BaseDNSResolver:
    def __init__(self):
        self.resolver = dns_asyncresolver.Resolver()
        self.resolver.timeout = config.dns_lifetime
        self.resolver.lifetime = config.dns_lifetime

    @timeit
    async def resolve(self, domain: str, r_type: str, raise_on_no_answer: bool = True):
        await self.resolver.resolve(domain, r_type, raise_on_no_answer=raise_on_no_answer, tcp=True)


class DNSPythonDNSResolver(BaseDNSResolver):
    def __init__(self):
        super().__init__()
        self.resolver.nameservers = [random.choice(config.authoritative_dns)]


DNSResolver: Type[BaseDNSResolver] = DNSPythonDNSResolver

if config.env_type == 'development':
    DNSResolver = BaseDNSResolver
