from typing import Optional

from . import Event


class DomainOccupiedEvent(Event):
    name = 'domain_occupied'

    def __init__(
        self,
        domain: str,
        new_owner_org_id: str,
        new_owner_new_domain_is_master: bool,
        old_owner_org_id: Optional[str],
        old_owner_new_master_name: Optional[str],
        old_owner_new_master_tech: Optional[bool],
    ):
        self.data = {
            'domain': domain,
            'new_owner_org_id': new_owner_org_id,
            'new_owner_new_domain_is_master': new_owner_new_domain_is_master,
            'old_owner_org_id': old_owner_org_id,
            'old_owner_new_master_name': old_owner_new_master_name,
            'old_owner_new_master_tech': old_owner_new_master_tech,
        }


class DomainDeletedEvent(Event):
    name = 'domain_deleted'

    def __init__(self, domain: str, org_id: str, author_id: Optional[str]):
        self.data = {
            'domain': domain,
            'org_id': org_id,
            'author_id': author_id,
        }


class DomainAddedEvent(Event):
    name = 'domain_added'

    def __init__(self, domain: str, org_id: str, author_id: Optional[str]):
        self.data = {
            'domain': domain,
            'org_id': org_id,
            'author_id': author_id,
        }


class DomainChangedEvent(Event):
    name = 'domain_changed'

    def __init__(self, domain: str, org_id: str, old_data: dict, new_data: dict):
        self.data = {
            'domain': domain,
            'org_id': org_id,
            'old_data': old_data,
            'new_data': new_data,
        }


class DomainMasterChangedEvent(Event):
    name = 'domain_master_changed'

    def __init__(self,
                 domain: str,
                 org_id: str,
                 admin_uid: str,
                 old_master_domain: Optional[str],
                 old_master_admin_uid: Optional[str]):
        self.data = {
            'domain': domain,
            'org_id': org_id,
            'admin_uid': admin_uid,
            'old_master_domain': old_master_domain,
            'old_master_admin_uid': old_master_admin_uid,
        }
