import logging
from fastapi.responses import JSONResponse
from fastapi import Request

from .base import BaseDomenatorException
from ...settings import config

logger = logging.getLogger(__name__)


async def base_exception_handler(request: Request, exc: BaseDomenatorException):
    """
    Обрабатывает все ошибки приложения и возвращает json с
    соответствующим кодом
    """
    return JSONResponse(
        status_code=exc.status_code,
        content=exc.to_json()
    )


async def unhandled_exception_handler(request, exc):
    logger.exception('Unhandled exception.')
    message = str(exc) if config.env_type != 'production' else 'Unhandled exception'
    return JSONResponse(
        status_code=500,
        content={'detail': message}
    )
